package gov.va.genisis2;

import java.util.List;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import gov.va.genisis2.ts.common.dto.TripleDTO;

/**
 * Model class to hold Term-Cli arguments
 * @author Michael Edoror
 *
 */
public class TermCliModel {
	private boolean noErrors;
	private boolean checkOnly;
	private boolean ignoreErrors;
	private boolean reportErrors;
	private boolean allowErrors;
	private boolean add;
	private boolean drop;
	private boolean verbose;
	private List<TripleDTO> properties;
	
	public TermCliModel() {
		noErrors = false;	
		checkOnly = false;
		ignoreErrors = false;
		reportErrors = false;
		allowErrors = false;
		verbose = false;
		add = false;
		drop = false;
		properties = null;
	}

	/**
	 * @return the allowErrors
	 */
	public boolean isAllowErrors() {
		return allowErrors;
	}

	/**
	 * @param allowErrors the allowErrors to set
	 */
	public void setAllowErrors(boolean allowErrors) {
		this.allowErrors = allowErrors;
	}

	/**
	 * @return the verbose
	 */
	public boolean isVerbose() {
		return verbose;
	}

	/**
	 * @param verbose the verbose to set
	 */
	public void setVerbose(boolean verbose) {
		this.verbose = verbose;
	}

	/**
	 * @return the add
	 */
	public boolean isAdd() {
		return add;
	}

	/**
	 * @param add the add to set
	 */
	public void setAdd(boolean add) {
		this.add = add;
	}

	/**
	 * @return the drop
	 */
	public boolean isDrop() {
		return drop;
	}

	/**
	 * @param drop the drop to set
	 */
	public void setDrop(boolean drop) {
		this.drop = drop;
	}

	/**
	 * @return the noErrors
	 */
	public boolean isNoErrors() {
		return noErrors;
	}

	/**
	 * @param noErrors the noErrors to set
	 */
	public void setNoErrors(boolean noErrors) {
		this.noErrors = noErrors;
	}

	/**
	 * @return the checkOnly
	 */
	public boolean isCheckOnly() {
		return checkOnly;
	}

	/**
	 * @param checkOnly the checkOnly to set
	 */
	public void setCheckOnly(boolean checkOnly) {
		this.checkOnly = checkOnly;
	}

	/**
	 * @return the ignoreErrors
	 */
	public boolean isIgnoreErrors() {
		return ignoreErrors;
	}

	/**
	 * @param ignoreErrors the ignoreErrors to set
	 */
	public void setIgnoreErrors(boolean ignoreErrors) {
		this.ignoreErrors = ignoreErrors;
	}

	/**
	 * @return the reportErrors
	 */
	public boolean isReportErrors() {
		return reportErrors;
	}

	/**
	 * @param reportErrors the reportErrors to set
	 */
	public void setReportErrors(boolean reportErrors) {
		this.reportErrors = reportErrors;
	}

	/**
	 * @return the properties
	 */
	public List<TripleDTO> getProperties() {
		return properties;
	}

	/**
	 * @param properties the properties to set
	 */
	public void setProperties(List<TripleDTO> properties) {
		this.properties = properties;
	}

	public String toJson() {
		ObjectMapper mapper = new ObjectMapper();
		String json = "";
		try {
			json = mapper.writeValueAsString(this);
		} catch (JsonProcessingException e) {
			e.printStackTrace();
		}
		return json;
	}
}
